def slideshow
    puts SLIDESHOW_START
    yield
    puts SLIDESHOW_END
end

def slide title
    puts "   <div class='slide'>"
    puts "    <h1>#{ title }</h1>"
    puts "    <ul>"
    yield
    puts "    </ul>"
    puts "   </div>"
end

def item text
    puts "     <li>#{ text.htmlspecialchars }</li>"
end

SLIDESHOW_START = <<END
<html>
 <head>
  <title>Ruby DSL-Generated S5 Presentation</title>
  <meta name="generator" content="S5" />
  <meta name="version" content="S5 1.3" />
  <meta http-equiv="content-type" content="text/html; charset=utf-8" />
  <!-- configuration parameters -->
  <meta name="defaultView" content="slideshow" />
  <meta name="controlVis" content="hidden" />
  <!-- configuration extensions -->
  <meta name="tranSitions" content="true" />
  <meta name="fadeDuration" content="500" />
  <meta name="incrDuration" content="250" />
  <!-- style sheet links -->
  <link rel="stylesheet" href="ui/scala_gfx/slides.css" type="text/css" media="projection" id="slideProj" />
  <link rel="stylesheet" href="ui/scala_gfx/outline.css" type="text/css" media="screen" id="outlineStyle" />
  <link rel="stylesheet" href="ui/scala_gfx/print.css" type="text/css" media="print" id="slidePrint" />
  <link rel="stylesheet" href="ui/scala_gfx/opera.css" type="text/css" media="projection" id="operaFix" />
  <!-- S5 JS -->
  <script src="ui/scala_gfx/slides.js" type="text/javascript"></script>
 </head>
 <body>
  <div class="layout">
   <div id="controls"><!-- DO NOT EDIT --></div>
   <div id="currentSlide"><!-- DO NOT EDIT --></div>
   <div id="header"></div>
   <div id="footer">
    <h1>Ruby DSL-Generated S5 Presentation</h1>
    <h2>#{Time.now}</h2>
   </div>
  </div>
  <div class='presentation'>
END

SLIDESHOW_END = <<END
  </div>
 </body>
</html>
END

class String
    def htmlspecialchars
        gsub('&', '&amp;').gsub('<', '&lt;').gsub('>', '&gt;')
    end
end

